const s8 default_aircount = 60;

MarkInfo@[] marked;
bool pressed = false;

class MarkInfo
{
	string player_username;
	bool clanMate;
	bool active;

	MarkInfo() {};
	MarkInfo(CPlayer@ _player, bool _clanMate)
	{
		player_username = _player.getUsername();
		clanMate = _clanMate;
		active = true;
	};

	CPlayer@ player() {
		return getPlayerByUsername(player_username);
	}
};

void onInit(CSprite@ this)
{
	if (marked.length == 0)
	{
		updateMarked(this);
	}

	this.getCurrentScript().runFlags |= Script::tick_myplayer;
	this.getCurrentScript().removeIfTag = "dead";
}

void onRender(CSprite@ this)
{
	CBlob@ blob = this.getBlob();
	if (getHUD().hasButtons())
	{
		return;
	}

	if ((getGameTime() % (30 * 30)) == 0)
	{
		updateMarked(this);
	}

	int deltaY = -2 + Maths::FastSin(getGameTime() / 4.5f) * 3.0f;
	for (uint i = 0; i < marked.length; i++)
	{
		if(marked[i].player() is null) break;

		CBlob@ blob = marked[i].player().getBlob();
		if (blob !is null && marked[i].active)
		{
			Vec2f p = blob.getPosition() + Vec2f(0.0f, -blob.getHeight() * 3.0f);
			p.x -= 8;
			Vec2f pos = getDriver().getScreenPosFromWorldPos(p);
			pos.y += deltaY;
			GUI::DrawIcon("GUI/PartyIndicator.png", marked[i].clanMate ? 2 : 1, Vec2f(16, 16), pos, getCamera().targetDistance);

			blob.SetMinimapVars("GUI/Minimap/MinimapIcons.png", 0, Vec2f(8, 8));
		}
	}

	//draw air bubbles
	u32 extra = 30;
	u32 offset = 45;
	u32 maxaircount = default_aircount + offset;
	s8 aircount = blob.get_s8("air_count") + offset + extra;
	if (aircount < default_aircount + offset + extra)
	{
		if (aircount > 0)
		{
			// draw drown indicator
			Vec2f p = blob.getPosition() + Vec2f(0.0f, -blob.getHeight() * 1.5f);
			p.x -= 8;
			Vec2f pos = getDriver().getScreenPosFromWorldPos(p);
			Vec2f dim(8, 8);

			s32 bubblecount = (maxaircount + 29) / 30;
			for (s32 bubble = 0; bubble < bubblecount; bubble++)
			{
				s32 frac = aircount - (bubble * 30);

				u32 frame = (frac > 30) ? 0 : (frac > 22) ? 1 : (frac > 14) ? 2 : 3;
				if (frac > 8)
				{
					GUI::DrawIcon("Sprites/Water/AirBubble.png", frame, dim,
					              pos + Vec2f(-((bubblecount - 1) / 2.0f - bubble - 0.5f) * dim.x, 0) * 2.0f * getCamera().targetDistance,
					              getCamera().targetDistance);
				}
			}
		}
	}

	//marking stuff
	if (getControls().ActionKeyPressed(AK_PARTY) && !pressed)
	{
		CMap@ map = getMap();
		if (map !is null)
		{
			CBlob@[] targets;
			if (map.getBlobsInRadius(this.getBlob().getAimPos(), 8.0f, @targets))
			{
				for (uint i = 0; i < targets.length; i++)
				{
					CBlob@ b = targets[i];
					if (b !is null && b.getPlayer() !is null)
					{
						CPlayer@ p = b.getPlayer();
						MarkInfo@ info = getMarkInfo(p);
						if (info is null)
						{
							marked.push_back(MarkInfo(p, false));
						}
						else if(info.player() is null)
						{
							continue;
						}
						else
						{
							info.active = !info.active;
							if (info.active)
							{

							}
							else
							{
								CBlob@ blob = info.player().getBlob();
								if (blob !is null)
								{
									blob.SetMinimapVars("GUI/Minimap/MinimapIcons.png", 8, Vec2f(8, 8));
								}
							}
						}
						break;
					}
				}
			}
		}
	}

	pressed = getControls().ActionKeyPressed(AK_PARTY);
}

void updateMarked(CSprite@ this)
{
	CPlayer@ local = this.getBlob().getPlayer();
	if (local is null || !local.isMyPlayer())
	{
		return;
	}

	if (marked.length == 0)
	{
		marked.push_back(MarkInfo(local, true));
	}

	if (local.getClantag() != "")
	{
		int count = getPlayerCount();
		for (uint i = 0; i < count; i++)
		{
			CPlayer@ p = getPlayer(i);
			if (p.getClantag() == local.getClantag() && p.getTeamNum() == local.getTeamNum() && p !is local)
			{
				MarkInfo@ info = getMarkInfo(p);
				if (info is null)
				{
					marked.push_back(MarkInfo(p, true));
				}
			}
		}
	}

	//remove missing players
	for (uint i = 0; i < marked.length; i++)
	{
		if (marked[i].player() is null)
		{
			marked.erase(uint(i--));
		}
	}

}

MarkInfo@ getMarkInfo(CPlayer@ player)
{
	string name = player.getUsername();
	for (uint i = 0; i < marked.length; i++)
	{
		if (marked[i].player_username == name)
		{
			return marked[i];
		}
	}
	return null;
}
